Attribute VB_Name = "modFileIO"
'-----------------------------------------------------
' MirageBot File Input/Output Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Public Declare Function GetPrivateProfileSection Lib "kernel32" Alias "GetPrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Public Declare Function WritePrivateProfileSection Lib "kernel32" Alias "WritePrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpString As String, ByVal lpFileName As String) As Long

Public Function CreateFile(File As String) As Boolean
On Error GoTo hErr:
    Dim FSO As New FileSystemObject
    If FSO.FileExists(File) = False Then FSO.CreateTextFile File: CreateFile = True
    Set FSO = Nothing
hErr:
End Function

Public Function CreateFolder(folder As String) As Boolean
On Error GoTo hErr:
    Dim FSO As New FileSystemObject
    If FSO.FolderExists(folder) = False Then FSO.CreateFolder folder: CreateFolder = True
    Set FSO = Nothing
hErr:
End Function

Public Function FolderList(Dir As String) As Folders
    Dim F As folder, S As Folders, FSO As New FileSystemObject
    Set F = FSO.GetFolder(Dir)
    Set S = F.SubFolders
    Set FolderList = S
End Function

Public Function FileList(Mask As String) As String()
On Error GoTo hErr
    Dim sFile As String, sList() As String, lCtr As Long
    ReDim sList(0) As String
    sFile = Dir$(Mask, vbNormal)
    Do While Len(sFile)
        If sList(0) = vbNullString Then
            sList(0) = sFile
        Else
            lCtr = UBound(sList) + 1
            ReDim Preserve sList(lCtr) As String
            sList(lCtr) = sFile
        End If
        sFile = Dir
    Loop
    FileList = sList
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "ReadWrite", "FileList"
End Function

Public Function ReadINI(ByRef File As String, ByRef Section As String, ByRef Key As String) As String
On Error GoTo hErr
    Dim Buffer As String * 256
2   GetPrivateProfileString Section, Key, vbNullString, Buffer, 256, File
3   If InStrB(Buffer, vbNullChar) <> 0 Then Buffer = Split(Buffer, vbNullChar)(0)
4   ReadINI = Trim$(Buffer)
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "ReadWrite", "ReadINI"
End Function

Public Sub WriteINI(ByRef File As String, ByRef Section As String, ByRef Key As String, ByRef Value As String)
On Error GoTo hErr
2   WritePrivateProfileString Section, Key, Value, File
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "ReadWrite", "WriteINI"
End Sub

Public Function ReadProfileSection(ByVal SectionName As String, ByVal FileName As String) As String()
    Const MaxSectionLen As Integer = 6120 'Read Up To 5kB From Section
    Dim strSectionData As String * MaxSectionLen 'Define buffer to receive section data
    Dim lngApiFnVal As Long
    lngApiFnVal = GetPrivateProfileSection(SectionName, strSectionData, MaxSectionLen, FileName)
    If lngApiFnVal Then
        ReadProfileSection = Split(Left(strSectionData, InStr(strSectionData, vbNullChar + vbNullChar) - 1), vbNullChar)
    Else
        ReDim ReadProfileSection(0)
    End If
End Function

Public Function DebugOutput(ByVal sIn As String) As String
On Error GoTo hErr
    Dim x1 As Long, y1 As Long
    Dim iLen As Long, iPos As Long
    Dim sB As String, ST As String
    Dim sOut As String
    Dim Offset As Long, sOffset As String
    iLen = Len(sIn)
    If iLen = 0 Then Exit Function
    sOut = vbNullString
    Offset = 0
    For x1 = 0 To ((iLen - 1) \ 16)
        sOffset = Right$("0000" & Hex$(Offset), 4)
        sB = Space$(48)
        ST = String$(16, ".")
        For y1 = 1 To 16
            iPos = 16 * x1 + y1
            If iPos > iLen Then Exit For
            Mid$(sB, 3 * (y1 - 1) + 1, 2) = Right$("00" & Hex$(Asc(Mid$(sIn, iPos, 1))), 2) & Space$(1)
            Select Case Asc(Mid$(sIn, iPos, 1))
            Case 0, 9, 10, 13
            Case Else
                Mid$(ST, y1, 1) = Mid$(sIn, iPos, 1)
            End Select
        Next y1
        If LenB(sOut) <> 0 Then sOut = sOut & vbCrLf
        sOut = sOut & sOffset & ":  " & sB & Space$(2) & ST
        Offset = Offset + 16
    Next x1
    DebugOutput = sOut
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "ReadWrite", "DebugOutput"
End Function
